/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerRiptideEvent;

public class TridentItem
extends Item
implements Vanishable {
    public static final int f_151230_ = 10;
    public static final float f_151231_ = 8.0f;
    public static final float f_151232_ = 2.5f;
    private final Multimap<Attribute, AttributeModifier> f_43379_;

    public TridentItem(Item.Properties p_43381_) {
        super(p_43381_);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 8.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)-2.9f, AttributeModifier.Operation.ADDITION));
        this.f_43379_ = builder.build();
    }

    @Override
    public boolean m_6777_(BlockState p_43409_, Level p_43410_, BlockPos p_43411_, Player p_43412_) {
        return !p_43412_.m_7500_();
    }

    @Override
    public UseAnim m_6164_(ItemStack p_43417_) {
        return UseAnim.SPEAR;
    }

    @Override
    public int m_8105_(ItemStack p_43419_) {
        return 72000;
    }

    @Override
    public void m_5551_(ItemStack p_43394_, Level p_43395_, LivingEntity p_43396_, int p_43397_) {
        if (p_43396_ instanceof Player) {
            int j;
            Player player = (Player)p_43396_;
            int i = this.m_8105_(p_43394_) - p_43397_;
            if (i >= 10 && ((j = EnchantmentHelper.m_44932_(p_43394_)) <= 0 || player.m_20070_())) {
                if (!p_43395_.f_46443_) {
                    if (j == 0) {
                        ThrownTrident throwntrident = new ThrownTrident(p_43395_, (LivingEntity)player, p_43394_);
                        throwntrident.m_37251_(player, player.m_146909_(), player.m_146908_(), 0.0f, 2.5f + (float)j * 0.5f, 1.0f);
                        if (player.m_150110_().f_35937_) {
                            throwntrident.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        if (!p_43395_.m_7967_(throwntrident)) {
                            if (player instanceof ServerPlayer) {
                                ((ServerPlayer)player).getBukkitEntity().updateInventory();
                            }
                            return;
                        }
                        p_43394_.m_41622_(1, player, p_43388_ -> p_43388_.m_21190_(p_43396_.m_7655_()));
                        throwntrident.f_37555_ = p_43394_.m_41777_();
                        p_43395_.m_6269_(null, throwntrident, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        if (!player.m_150110_().f_35937_) {
                            player.m_150109_().m_36057_(p_43394_);
                        }
                    } else {
                        p_43394_.m_41622_(1, player, entityhuman1 -> entityhuman1.m_21190_(p_43396_.m_7655_()));
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_(this));
                if (j > 0) {
                    PlayerRiptideEvent event = new PlayerRiptideEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror((ItemStack)p_43394_));
                    event.getPlayer().getServer().getPluginManager().callEvent((Event)event);
                    float f7 = player.m_146908_();
                    float f = player.m_146909_();
                    float f1 = -Mth.m_14031_((float)(f7 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
                    float f2 = -Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
                    float f3 = Mth.m_14089_((float)(f7 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
                    float f4 = Mth.m_14116_((float)(f1 * f1 + f2 * f2 + f3 * f3));
                    float f5 = 3.0f * ((1.0f + (float)j) / 4.0f);
                    player.m_5997_(f1 *= f5 / f4, f2 *= f5 / f4, f3 *= f5 / f4);
                    player.m_204079_(20);
                    if (player.m_20096_()) {
                        float f6 = 1.1999999f;
                        player.m_6478_(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                    }
                    SoundEvent soundevent = j >= 3 ? SoundEvents.f_12519_ : (j == 2 ? SoundEvents.f_12518_ : SoundEvents.f_12517_);
                    p_43395_.m_6269_(null, player, soundevent, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level p_43405_, Player p_43406_, InteractionHand p_43407_) {
        ItemStack itemstack = p_43406_.m_21120_(p_43407_);
        if (itemstack.m_41773_() >= itemstack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)((Object)itemstack));
        }
        if (EnchantmentHelper.m_44932_(itemstack) > 0 && !p_43406_.m_20070_()) {
            return InteractionResultHolder.m_19100_((Object)((Object)itemstack));
        }
        p_43406_.m_6672_(p_43407_);
        return InteractionResultHolder.m_19096_((Object)((Object)itemstack));
    }

    @Override
    public boolean m_7579_(ItemStack p_43390_, LivingEntity p_43391_, LivingEntity p_43392_) {
        p_43390_.m_41622_(1, p_43392_, p_43414_ -> p_43414_.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    @Override
    public boolean m_6813_(ItemStack p_43399_, Level p_43400_, BlockState p_43401_, BlockPos p_43402_, LivingEntity p_43403_) {
        if ((double)p_43401_.m_60800_((BlockGetter)((Object)p_43400_), p_43402_) != 0.0) {
            p_43399_.m_41622_(2, p_43403_, p_43385_ -> p_43385_.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    @Override
    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot p_43383_) {
        return p_43383_ == EquipmentSlot.MAINHAND ? this.f_43379_ : super.m_7167_(p_43383_);
    }

    @Override
    public int m_6473_() {
        return 1;
    }
}

